/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.client;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="abnormals_core", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ChestManager {
    private static final Map<String, ChestInfo> CHEST_INFO_MAP = new HashMap<String, ChestInfo>();

    public static synchronized void putChestInfo(String modId, String type, boolean trapped) {
        CHEST_INFO_MAP.put(modId + ":" + type + (trapped ? "_trapped" : ""), new ChestInfo(modId, type, trapped));
    }

    @Nullable
    public static ChestInfo getInfoForChest(String chestType) {
        return CHEST_INFO_MAP.get(chestType);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            for (ChestInfo chestInfo : CHEST_INFO_MAP.values()) {
                chestInfo.setup(event);
            }
        }
    }

    public static class ChestInfo {
        private final ResourceLocation single;
        private final ResourceLocation left;
        private final ResourceLocation right;
        @OnlyIn(value=Dist.CLIENT)
        private RenderMaterial singleMaterial;
        @OnlyIn(value=Dist.CLIENT)
        private RenderMaterial leftMaterial;
        @OnlyIn(value=Dist.CLIENT)
        private RenderMaterial rightMaterial;

        public ChestInfo(String modId, String type, boolean trapped) {
            String chest = trapped ? "trapped" : "normal";
            this.single = new ResourceLocation(modId, "entity/chest/" + type + "/" + chest);
            this.left = new ResourceLocation(modId, "entity/chest/" + type + "/" + chest + "_left");
            this.right = new ResourceLocation(modId, "entity/chest/" + type + "/" + chest + "_right");
        }

        @OnlyIn(value=Dist.CLIENT)
        private void setup(TextureStitchEvent.Pre event) {
            event.addSprite(this.single);
            event.addSprite(this.left);
            event.addSprite(this.right);
            this.singleMaterial = new RenderMaterial(Atlases.field_228747_f_, this.single);
            this.leftMaterial = new RenderMaterial(Atlases.field_228747_f_, this.left);
            this.rightMaterial = new RenderMaterial(Atlases.field_228747_f_, this.right);
        }

        @OnlyIn(value=Dist.CLIENT)
        public RenderMaterial getSingleMaterial() {
            return this.singleMaterial;
        }

        @OnlyIn(value=Dist.CLIENT)
        public RenderMaterial getLeftMaterial() {
            return this.leftMaterial;
        }

        @OnlyIn(value=Dist.CLIENT)
        public RenderMaterial getRightMaterial() {
            return this.rightMaterial;
        }
    }
}

